dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 220, 220, "assets/images/table/castle_6", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 2, 4, 200, 350, "assets/images/table/castle", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 2, 420, 350, "assets/images/table/castle_2", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 4, 8, 200, 485, "assets/images/table/castle_8", "assets/images/food/item_mark4", "B" );

numServers = 1;
useFloAsServer = 1;

useWineTable = 1;
numMoodBoosts = 3;
maxCoupleHappiness = 500;

--Level 5.10

--Group 1
guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = aunt;
guest.percentRequestMusic = 30;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 4, 1000);


--Group 2
guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table2;
guest.percentRequestDrink = 20;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 8, 16000);


--Group 3
guest = LManager.GenGuest(aunt);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.likes={female04};
guest.matchType = aunt;
guest.percentRequestDrink = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 10, 28000);


-- Group 4
guest = LManager.GenGuest(female03);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female01;
guest.percentRequestMusic = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.likes={aunt};
guest.matchType = male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 16, 40000);


--Group 5

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table3;
guest.percentRequestDrink = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(17, 20, 75000);


--Group 6

guest = LManager.GenGuest(male03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(21, 26, 100000);

-- Group 7
guest = LManager.GenGuest(aunt);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(27, 28, 120000);


-- Group 8
guest = LManager.GenGuest(female01);
guest.matchType = aunt;
guest.percentRequestMusic = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(29, 30, 160000);


-- Group 9
guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(31, 33, 220000);


-- Group 10
guest = LManager.GenGuest(female02);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table1;
guest.percentRequestDrink = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(34, 36, 240000);

-- Group 11

guest = LManager.GenGuest(female02);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male04;
guest.percentRequestDrink = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(37, 38, 270000);


-- Group 12

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
guest.percentRequestMusic = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(39, 42, 300000);

-- Group 13

guest = LManager.GenGuest(male03);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table3;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(43, 45, 320000);

-- Group 14

guest = LManager.GenGuest(male01);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(46, 48, 340000);


LManager:AdjustGuestTolerance(140);

LManager:SetLevelSetting ("dogDelay", 75000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("cakeTipDelay", 140000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("speakerDelay", 210000); 
LManager:SetLevelSetting ("speakerChance", 40);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 280000 );

LManager:AddReseatingRequestForGuest( 100000, female04 );
LManager:AddReseatingRequestForGuest( 130000, male03 );
LManager:AddReseatingRequestForGuest( 150000, male01 );
LManager:AddReseatingRequestForGuest( 180000, female03 );
LManager:AddReseatingRequestForGuest( 260000, female01 );
LManager:AddReseatingRequestForGuest( 300000, uncle );

-- Set up the Level Settings
LManager:SetLevelNumber(5,10);
LManager:SetLevelScores(24000, 29000);
LManager:SetLevelTime(400000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/Dance Dance 1.ogg","assets/audio/music/uptempo_3.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );